<?php
/**
 * Copyright © 2015 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */

/**
 * Catalog fieldset element renderer
 *
 * @author      Magento Core Team <core@magentocommerce.com>
 */
namespace Codazon\ProductLabel\Block\Adminhtml\ProductLabel\AbstractHtmlField;

class Element extends \Codazon\ProductLabel\Block\Adminhtml\ProductLabel\AbstractHtmlField
{
    /**
     * Initialize block template
     */
    protected $_template = 'Codazon_ProductLabel::productlabel/content_html/renderer/fieldset/element.phtml';
    /**
     * Retrieve element label html
     *
     * @return string
     */
    public function getElementLabelHtml()
    {
        $element = $this->getElement();
        $label = $element->getLabel();
        if (!empty($label)) {
            $element->setLabel(__($label));
        }
        return $element->getLabelHtml();
    }

    /**
     * Retrieve element html
     *
     * @return string
     */
    public function getElementHtml()
    {
        return $this->getElement()->getElementHtml();
    }
}
