<?php

namespace App\Http\Controllers;

use App\Http\Requests\ProfileUpdateRequest;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;
use Illuminate\View\View;
use Illuminate\Support\Facades\DB;

class ProfileController extends Controller
{
    /**
     * Display the user's profile form.
     */
    public function edit(Request $request): View
    {
        return view('profile.edit', [
            'user' => $request->user(),
        ]);
    }

    /**
     * Update the user's profile information.
     */
    public function update(ProfileUpdateRequest $request): RedirectResponse
    {
        $request->user()->fill($request->validated());

        if ($request->user()->isDirty('email')) {
            $request->user()->email_verified_at = null;
        }

        $request->user()->save();

        return Redirect::route('profile.edit')->with('status', 'profile-updated');
    }

    /**
     * Delete the user's account.
     */
    public function destroy(Request $request): RedirectResponse
    {
        $request->validateWithBag('userDeletion', [
            'password' => ['required', 'current_password'],
        ]);

        $user = $request->user();

        Auth::logout();

        $user->delete();

        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return Redirect::to('/');
    }

    public function my_bids(Request $request)
    {
        $user = $request->user();

        $results = DB::table('bids')                
                ->leftJoin('users', 'bids.user_id', '=', 'users.id')
                ->leftJoin('products', 'bids.product_id', '=', 'products.id')     
                ->where('bids.user_id', $user->id)             
                ->select('products.name as pd_name','products.image as pd_image','products.descrip as pd_descrip','users.name','users.email','users.id',
                        'users.created_at','products.id as pd_id', DB::raw('count(bids.product_id) as product_bids')) 
                ->groupBy('products.id','users.name','users.email','users.created_at','products.name', 'products.image','products.descrip','products.created_at',
                          'users.id') 
                ->orderBy('bids.updated_at', 'desc')            
                ->get();

        return view('profile.mybids', compact('results'));
    }

    public function my_wins(Request $request)
    {
        $user = $request->user();

        $results = Db::table('bid_winners')
                        ->leftJoin('users', 'bid_winners.user_id', '=', 'users.id')
                        ->leftJoin('products', 'bid_winners.product_id', '=', 'products.id') 
                        ->where('bid_winners.user_id', $user->id)   
                        ->select('products.name as pd_name','products.image as pd_image','products.descrip as pd_descrip','users.name','users.email','users.id',
                        'users.created_at','products.id as pd_id','bid_winners.id' ,'bid_winners.bid_id','bid_winners.drawn_date') 
                        ->orderBy('bid_winners.updated_at', 'desc')            
                        ->get();
        //echo '<pre>'; print_r($results); exit;
        return view('profile.mywins', compact('results'));
    }   

}
