<x-admin.wrapper>
    <x-slot name="title">
        {{ __('Bid Winners') }}
    </x-slot>   
    @session('success')
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ $value }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endsession
    <div class="py-2">
        <div class="min-w-full  border-base-200 shadow overflow-x-auto">
        @if($results->isEmpty())
        <table><tr>
                <td colspan="2">
                    <div class="flex flex-col justify-center items-center py-4 text-lg">
                        {{ __('No Result Found') }}
                    </div>
                </td>
            </tr></table>
        @endif
        @if(!$results->isEmpty())
            <x-admin.grid.table>
                <x-slot name="head">
                    <tr class="bg-base-200">
                    <x-admin.grid.th>
                        {{ __('Image') }}
                        </x-admin.grid.th>
                        <x-admin.grid.th>
                        {{ __('Bid Name') }}
                        </x-admin.grid.th>                        
                        <x-admin.grid.th>
                        {{ __('Winner') }}
                        </x-admin.grid.th>
                        <x-admin.grid.th>
                        {{ __('Winner Email') }}
                        </x-admin.grid.th>
                        <x-admin.grid.th>
                        {{ __('Drawn Date') }}
                        </x-admin.grid.th>
                        <x-admin.grid.th>
                            {{ __('Bid Id') }}
                        </x-admin.grid.th>                       
                        <x-admin.grid.th>
                            {{ __('Actions') }}
                        </x-admin.grid.th>                       
                    </tr>
                </x-slot>
                <x-slot name="body">
                    @foreach($results as $result)
                        <tr>
                            <x-admin.grid.td>
                                <div class="text-sm text-gray-900" style="margin-left:10px;">
                                   <img src="{{asset('storage')}}/{{ $result->pd_image }}" width="70">
                                </div>
                            </x-admin.grid.td>
                            <x-admin.grid.td>
                                <div class="text-sm text-gray-900" style="margin-left:10px;">
                                    {{ $result->pd_name }}
                                </div>
                            </x-admin.grid.td>
                            <x-admin.grid.td>
                                <div class="text-sm text-gray-900">
                                {{ $result->name }}
                                </div>
                            </x-admin.grid.td>
                            <x-admin.grid.td>
                                <div class="text-sm text-gray-900">
                                {{ $result->email }}
                                </div>
                            </x-admin.grid.td>
                            <x-admin.grid.td>
                                <div class="text-sm text-gray-900">                                
                                {{ \Carbon\Carbon::parse($result->drawn_date)->format('d M Y') }}
                                </div>
                            </x-admin.grid.td>
                            <x-admin.grid.td>
                                <div class="text-sm text-gray-900">
                                {{ $result->bid_id }}
                                </div>
                            </x-admin.grid.td>
                            
                            <x-admin.grid.td>
                            <a href="{{route('admin.bids.view', $result->pd_id) }}" class="btn btn-square btn-ghost">View Details</a>
                            </x-admin.grid.td>   
                        </tr>
                    @endforeach
                    
                </x-slot>
            </x-admin.grid.table>
        @endif    
        </div>
    </div>
</x-admin.wrapper>