<x-admin.wrapper>
    <x-slot name="title">
        {{ __('Update Product') }}
    </x-slot>  
    <div class="w-full py-2 overflow-hidden">
    @if($product->bid_status=='pending' || $product->bid_status=='open')
        <form action="{{ route('admin.products.update', $product->id) }}" method="POST" enctype="multipart/form-data">
            @csrf  
            @method('PUT')
            <div class="form-control py-2">
                <label for="name" class="block font-medium text-sm text-base-700">Product Name:</label>
                <input type="text" name="name" id="name" required class="input input-bordered w-full mt-2" value="{{ $product->name }}">
            </div>
            <!--
            <div class="form-control py-2">
                <label for="quantity" class="block font-medium text-sm text-base-700">Slug:</label>
                <input type="text" name="slug_url" id="quantity" class="input input-bordered w-full mt-2" value="{{ $product->slug_url }}">
            </div>
            -->    
            <div class="form-control py-2">
                <label for="descrip" class="block font-medium text-sm text-base-700">Description:</label>
                <textarea name="descrip" id="descrip" class="input input-bordered w-full mt-2">{{ $product->descrip }}</textarea>
            </div>
            <div class="form-control py-2">
                <label for="price" class="block font-medium text-sm text-base-700">Price:</label>
                <input type="text" name="price" id="price" required class="input input-bordered w-full mt-2" value="{{ $product->price }}">
            </div>

            <div class="form-control py-2">
                <label for="status" class="block font-medium text-sm text-base-700">Status:</label>
                <select name="status" id="status" required class="input input-bordered w-full mt-2">
                        <option value="1" 
                        @if($product->status==1)
                         selected="selected"
                        @endif
                        >Enable</option>
                        <option value="0"
                        @if($product->status==0)
                         selected="selected"
                        @endif
                        >Disable</option>
                </select>    
            </div>
            <div class="form-control py-2">
                <label for="bid_status" class="block font-medium text-sm text-base-700">Bid Status:</label>
                <select name="bid_status" id="bid_status" required class="input input-bordered w-full mt-2">
                    @if($product->bid_status=='pending')
                        <option value="open">Open</option>
                        <option value="pending" selected="selected">Pending</option>
                    @endif
                    @if($product->bid_status=='open')
                        <option value="open" selected="selected">Open</option>
                        <option value="closed">Closed</option>
                        <option value="cancelled">Cancelled</option>
                    @endif        
                </select>    
            </div>
            <div class="form-control py-2">
                <label for="jackpots" class="block font-medium text-sm text-base-700">Jackpots:</label>
                <input type="number" name="jackpots" id="jackpots" required class="input input-bordered w-full mt-2" min="{{ env('MIN_JACKPOT') }}" value="{{ $product->jackpots }}">
            </div>
            <div class="form-control py-2">
                <label for="start_date" class="block font-medium text-sm text-base-700">Start Date:</label>
                <input type="date" name="start_date" id="start_date" 
                @if( \Carbon\Carbon::parse($product->start_date)->format('Y-m-d') >= now()->toDateString('Y-m-d'))
                    min="{{ now()->toDateString('Y-m-d') }}" 
                @else
                    min="{{ \Carbon\Carbon::parse($product->start_date)->format('Y-m-d') }}" 
                @endif
                max="{{ now()->addYears(1)->toDateString('Y-m-d') }}" value="{{ \Carbon\Carbon::parse($product->start_date)->format('Y-m-d') }}" required class="input input-bordered w-full mt-2">
            </div>
            <div class="form-control py-2">
                <label for="end_date" class="block font-medium text-sm text-base-700">End Date:</label>
                <input type="date" name="end_date" id="end_date"
                @if( \Carbon\Carbon::parse($product->start_date)->format('Y-m-d') >= now()->toDateString('Y-m-d'))
                    min="{{ now()->toDateString('Y-m-d') }}" 
                @else
                    min="{{ \Carbon\Carbon::parse($product->start_date)->format('Y-m-d') }}" 
                @endif                
                max="{{ now()->addYears(3)->toDateString('Y-m-d') }}" value="{{ \Carbon\Carbon::parse($product->end_date)->format('Y-m-d') }}" required class="input input-bordered w-full mt-2">
            </div>

            <div class="form-control py-2">
                <label for="image" class="block font-medium text-sm text-base-700">Upload Image:</label>
                <input type="file" name="image" id="image" class="input input-bordered w-full mt-2"> 
                @if( !empty($product->image))
                <img src="{{ asset('storage/'.$product->image) }}" alt="Uploaded Image" style="width: 150px;">
                @endif
            </div>
             <input type="hidden" name="id" value="{{ $product->id }}">       
            <div class="flex justify-end mt-4"><button type="submit" class="btn btn-primary px-6">Update</button></div>
        </form>
        @else
            <h3> You can only edit product when Bid-status is Open or Pending </h3>
        @endif

    </div>
    </x-admin.wrapper>