<?php

namespace BalajiDharma\LaravelAdminCore\Requests\User;

use BalajiDharma\LaravelAdminCore\Data\User\UserUpdateData;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules;

class UpdateUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users,email,'.$this->user->id],
            'password' => ['nullable', 'confirmed', Rules\Password::defaults()],
        ];
    }

    public function getUserData(): UserUpdateData
    {
        return UserUpdateData::from($this);
    }
}
