<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Products;
use App\Models\Bids;
use App\Models\Order;
use App\Models\Order_item;
use App\Models\Transaction;
use Stripe;
use Illuminate\View\View;
use Illuminate\Http\RedirectResponse;
use Illuminate\Pagination\LengthAwarePaginator;

class ProductController extends Controller
{
    ### product listing on home page
    public function index(Request $request)
    {
        //$products = Products::all();
       
        $products = DB::table('products')            
                        ->leftJoin('bids', 'products.id', '=', 'bids.product_id')                
                        ->select('products.*', DB::raw('COUNT(bids.product_id) as total_bids')) 
                        ->where('products.bid_status', 'open') 
                        ->where('products.start_date', '<=', date('Y-m-d')) 
                        ->where('products.end_date', '>=', date('Y-m-d'))               
                        ->groupBy('products.id','products.name','products.image','products.descrip','products.slug_url','products.price','products.status',
                                'products.start_date','products.end_date','products.bid_status','products.jackpots','products.created_at','products.updated_at') 
                        //->having('total_bids', '>=', 1)                                
                        ->orderBy('bids.updated_at', 'desc')
                        ->get();

        $page = request()->get('page', 1); // Current page, defaults to 1
        $perPage = 10; // Items per page
        $offset = ($page - 1) * $perPage;
        
        // Paginate the collection
        $paginatedProducts = new LengthAwarePaginator(
            $products->slice($offset, $perPage), // Items for the current page
            $products->count(), // Total items in the collection
            $perPage, // Items per page
            $page, // Current page
            ['path' => request()->url(), 'query' => request()->query()] // Preserve query parameters
        );        
        
        return view('products.index', compact('products','paginatedProducts'));
    }

    ### product -cart  ####
    public function productCart()
    {
        return view('cart');
    }


    public function addProductToCart(Request $request)
    {
        $request->session()->forget('cart'); 
        $productId = $request->input('product_id');
        $quantity = $request->input('quantity', 1);
        $cartItemId = $request->input('cart_item_id');

        $product = Products::find($productId);

        if (!$product) {
            return redirect()->route('products.index')->with('error', 'Product not found!');
        }

        // Add product to cart
        $cart = session()->get('cart', []);
        $cart[$productId] = [
            'id' => $product->id,
            'name' => $product->name,
            'price' => $product->price,
            'quantity' => 1,
            "poster" => $product->image
        ];
        

        $totalQuantity = 0;
        $total_amount = 0;
        foreach ($cart as $item) {
            $totalQuantity += $item['quantity'];
            $total_amount += $product->price;
        }
        
        session()->put('cart', $cart);
        return response()->json(['message' => 'Cart updated', 'cartCount' => $totalQuantity], 200);

        //return  redirect()->route('checkout');
    }

    public function deleteItem(Request $request)
    {
        if($request->id) {
            $cart = session()->get('cart');
            if(isset($cart[$request->id])) {
                unset($cart[$request->id]);
                session()->put('cart', $cart);
            }
            session()->flash('success', 'Product successfully deleted.');
        }
    }

    /**
     * success response method.
     *
     * @return \Illuminate\Http\Response
     */
    public function stripe(): View
    {        
        
       return view('products.stripe');       
        
    }
      
    /**
     * success response method.
     *
     * @return \Illuminate\Http\Response
     */
    public function stripePost(Request $request): RedirectResponse
    {
        $user = $request->user();
        Stripe\Stripe::setApiKey(env('STRIPE_SECRET'));

        $ncart = session()->get('cart');
        //echo '<pre>'; print_r($ncart ); echo '</pre>';

        $total = 0;
        if($ncart){
            foreach($ncart  as $t){
                $total += $t['price'];
            }
        }
      
        $charge = Stripe\Charge::create ([
                "amount" => $total * 100,
                "currency" => "usd",
                "source" => $request->stripeToken,
                "description" => $request->pd_name.'-----email-'.$user->email.' ---name--- '.$user->name,                                
                "ip" => $request->ip(),
        ]);
         
         //echo '<pre>';          print_r($charge);  echo '</pre>';  
         if($charge['paid'])
         {  
            //save data in Order table
            $Order = new Order;
            $Order->user_id = $user->id;
            $Order->user_name = $user->name;
            $Order->user_email = $user->email;
            $Order->ip_address = $request->ip();
            $Order->total =$total;
            $Order->grand_total = $total;
            $Order->status = 'processing';
            $Order->save();

            //save data in Order_item
            
            foreach($ncart  as $tcart){

                $OrderItem = new Order_item;
                $OrderItem->product_id = $tcart['id'];
                $OrderItem->product_name = $tcart['name'];
                $OrderItem->price = $tcart['price'];
                $OrderItem->quantity = 1;
                $OrderItem->order_id = $Order->id;
                $OrderItem->save();
            }

            $Transaction = new Transaction;
            $Transaction->order_id = $Order->id;
            $Transaction->user_id  = $user->id;
            $Transaction->status = 'Paid';
            $Transaction->code = $charge['id'];
            $Transaction->type = $charge['payment_method'];
            $Transaction->mode = $charge['balance_transaction'];
            $Transaction->descrip = $charge['description'];
            $Transaction->save();

            $Bid = new Bids;
            $Bid->user_id = $user->id;
            $Bid->product_id = $tcart['id'];
            $Bid->order_id = $Order->id;
            $Bid->save();


            $request->session()->forget('cart');  
        }       
        //return back()->with('success', 'Payment successful!');
        return  redirect()->route('product.index')->with('success', 'Bid Placed sussessfully as well as Payment successful!');
    }


}
