<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Bids;
use App\Models\User;

class PickBidWinner extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'bids:pick-winner';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Pick a random winner from the bids';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        // Get all bids
        $bids = Bids::all();

        // Check if there are any bids
        if ($bids->isEmpty()) {
            $this->info('No bids found.');
            return 0;
        }

        // Select a random bid
        $randomBid = $bids->random();

        // Get the winner (user) from the random bid
        $winner = User::find($randomBid->user_id);

        // Output the winner's details
        $this->info('The winner is: ' . $winner->name . ' (User ID: ' . $winner->id . ')');
        
        return 0;
    }
}
