<?php namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;
use Illuminate\Support\Facades\DB;
use App\Models\Products;
use App\Models\Bids;
use App\Models\BidWinners;
use App\Models\Users;


class BidsController extends Controller
{

   /**
     * Display a listing of the resource.
     *
     * @return View
     */
    public function index(Request $request): View
    {
        $user = auth()->user();
        if($user->role !=='admin'){exit;}

        $results = DB::table('products')                
                ->leftJoin('bids', 'products.id', '=', 'bids.product_id')                
                ->select('products.name as pd_name','products.image as pd_image','products.descrip as pd_descrip','products.bid_status as bid_status','products.created_at as pd_created', 
                          DB::raw('COUNT(bids.product_id) as total_bids'),'products.id as pd_id')
                ->groupBy('products.id','products.name','products.image','products.descrip','products.created_at','products.bid_status') 
                ->having('total_bids', '>=', 1)                
                ->orderBy('bids.updated_at', 'desc')
                ->get();
        //echo '<pre>'; print_r($results);

        return view('admin.bids.index', compact('results'));
    } 

     /**
     * Display a listing of the resource.
     *
     * @return View
     */
    public function detail($id): View
    {
        $user = auth()->user();
        if($user->role !=='admin'){exit;}

        
        $results = DB::table('bids')                
                ->leftJoin('users', 'bids.user_id', '=', 'users.id')
                ->leftJoin('products', 'bids.product_id', '=', 'products.id')     
                ->where('bids.product_id', $id)             
                ->select('products.name as pd_name','products.image as pd_image','products.descrip as pd_descrip','products.created_at as pd_created',
                        'users.id','users.name','users.email','products.id as pd_id', DB::raw('count(bids.user_id) as user_bids'))
                ->groupBy('users.id','users.name','users.email','products.name', 'products.image','products.descrip','products.created_at','products.id')            
                ->orderBy('bids.updated_at', 'desc')            
                ->get();
           
         // $results = DB::raw('SELECT products.name as pd_name,products.image as pd_image,products.descrip as pd_descrip, products.created_at as pd_created, users.*,products.id as pd_id, count(bids.user_id) as user_bids FROM `bids` left join users on bids.user_id = users.id left join products on bids.product_id = products.id where bids.product_id = 1 group by users.id;') 
                        ;     
       // echo '<pre>'; print_r($results); exit;

        return view('admin.bids.detail', compact('results'));
    } 

    /**
     * Display a listing of the resource.
     *
     * @return View
     */
    public function userdetail($id): View
    {
        $user = auth()->user();
        if($user->role !=='admin'){exit;}

        $results = DB::table('bids')                
                ->leftJoin('users', 'bids.user_id', '=', 'users.id')
                ->leftJoin('products', 'bids.product_id', '=', 'products.id')     
                ->where('bids.user_id', $id)             
                ->select('products.name as pd_name','products.image as pd_image','products.descrip as pd_descrip','users.name','users.email','users.id',
                        'users.created_at','products.id as pd_id', DB::raw('count(bids.product_id) as product_bids')) 
                ->groupBy('products.id','users.name','users.email','users.created_at','products.name', 'products.image','products.descrip','products.created_at',
                          'users.id') 
                ->orderBy('bids.updated_at', 'desc')            
                ->get();

                
       // echo '<pre>'; print_r($results); exit;

        return view('admin.bids.user', compact('results'));
    } 
}