<?php namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;
use App\Http\Requests\StoreProductRequest;
use App\Http\Requests\UpdateProductRequest;
use App\Models\Products;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Intervention\Image\ImageManager;
use Intervention\Image\Drivers\Gd\Driver;


class ProductsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return View
     */
    public function index(Request $request): View
    {
        $user = auth()->user();
        if($user->role !=='admin'){exit;}
        $products = Products::all();

        return view('admin.products.index', compact('products'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return View
     */
    public function create(): View
    {
        $user = auth()->user();
        if($user->role !=='admin'){exit;}

        return view('admin.products.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  StoreProductRequest  $request
     * @return RedirectResponse
     */
    public function store(StoreProductRequest $request): RedirectResponse
    {
        $user = auth()->user();
        if($user->role !=='admin'){exit;}

        //$request->validate([    'image' => 'image|mimes:jpeg,png,jpg,gif|max:2048',    ]);
        $input_data = $request->all();
        //echo '<pre>'; print_r($input_data); echo '</pre>'; exit();
        $add_data =[
            'name'     => $input_data['name'],
            //'slug_url' => $input_data['slug_url'],
            'descrip'  => $input_data['descrip'],
            'price'    => $input_data['price'],
            'status'    => $input_data['status'],
            'bid_status'    => $input_data['bid_status'],
            'jackpots'    => $input_data['jackpots'],
            'start_date'    => $input_data['start_date'],
            'end_date'    => $input_data['end_date'],
        ];

        if ($request->hasFile('image')) 
        {   
            $manager = new ImageManager(new Driver());
            $image2 = $request->file('image');
            $newImageName = Str::uuid() . '.' . $image2->getClientOriginalExtension();  
            $image = $manager->read($image2);
            $image->scale(width: 150);            
            $image->save('storage/media/uploads/bids/'.$newImageName);
            $add_data['image'] = 'media/uploads/bids/'.$newImageName; 
        }

        Products::create($add_data);
        //Products::create($request->validated());
        return redirect()->route('admin.products.index');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  Product  $product
     * @return View
     */
    public function edit($id): View
    {
        $user = auth()->user();
        if($user->role !=='admin'){exit;}

        $product = Products::findOrFail($id);
        //print_r($product);

        return view('admin.products.edit', compact('product'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  UpdateProductRequest  $request
     * @param  Product  $product
     * @return RedirectResponse
     */
    public function update(UpdateProductRequest $request, Products $product): RedirectResponse
    {
        $user = auth()->user();
        if($user->role !=='admin'){exit;}

        //echo '<pre>';
        $input_data = $request->all();
        $id = $input_data['id'];
        $update_data = [
            'name' => $input_data['name'],
            //'slug_url' => $input_data['slug_url'],
            'descrip' => $input_data['descrip'],
            'price' => $input_data['price'],
            'status'    => $input_data['status'],
            'bid_status'    => $input_data['bid_status'],
            'jackpots'    => $input_data['jackpots'],
            'start_date'    => $input_data['start_date'],
            'end_date'    => $input_data['end_date'],
        ];

        if ($request->hasFile('image')) 
        {   
            $manager = new ImageManager(new Driver());
            $image2 = $request->file('image');
            $newImageName = Str::uuid() . '.' . $image2->getClientOriginalExtension();  
            $image = $manager->read($image2);
            $image->scale(width: 150);            
            $image->save('storage/media/uploads/bids/'.$newImageName);
            $update_data['image'] = 'media/uploads/bids/'.$newImageName; 
        }
        
        //echo '--------------'.$input_data['id'];
        //print_r($request->all());echo '</pre>';
        
        //$product->update($request->validated());
        $product = Products::findOrFail($id);
        $product->update($update_data);

        return redirect()->route('admin.products.index')->with('success', 'Product updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  Product  $product
     * @return RedirectResponse
     */
    public function destroy(Request $request): RedirectResponse
    {
        $user = auth()->user();        
        if($user->role !=='admin'){exit;}     

        $id = $request->get('id');
        $product = Products::findOrFail($id);
        $product->delete();

       return redirect()->route('admin.products.index')->with('success', 'Product deleted successfully.');
    }
}