<x-admin.wrapper>
    <x-slot name="title">
        {{ __('Add Product') }}
    </x-slot>  
    <div class="w-full py-2 overflow-hidden">
        <form action="{{ route('admin.products.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="form-control py-2">
                <label for="name" class="block font-medium text-sm text-base-700">Product Name:</label>
                <input type="text" name="name" id="name" required class="input input-bordered w-full mt-2">
            </div>
            <!--<div class="form-control py-2">
                <label for="quantity" class="block font-medium text-sm text-base-700">Slug:</label>
                <input type="text" name="slug_url" id="quantity" required class="input input-bordered w-full mt-2">
            </div>-->
            <div class="form-control py-2">
                <label for="descrip" class="block font-medium text-sm text-base-700">Description:</label>
                <textarea name="descrip" id="descrip" class="input input-bordered w-full mt-2"></textarea>
            </div>
            <div class="form-control py-2">
                <label for="price" class="block font-medium text-sm text-base-700">Price:</label>
                <input type="text" name="price" id="price" required class="input input-bordered w-full mt-2">
            </div>

            <div class="form-control py-2">
                <label for="status" class="block font-medium text-sm text-base-700">Status:</label>
                <select name="status" id="status" required class="input input-bordered w-full mt-2">
                        <option value="1" selected="selected">Enable</option>
                        <option value="0">Disable</option>
                </select>    
            </div>

            <div class="form-control py-2">
                <label for="bid_status" class="block font-medium text-sm text-base-700">Bid Status:</label>
                <select name="bid_status" id="bid_status" required class="input input-bordered w-full mt-2">
                        <option value="open" selected="selected">Open</option>
                        <option value="pending">Pending</option>
                </select>    
            </div>
            <div class="form-control py-2">
                <label for="jackpots" class="block font-medium text-sm text-base-700">Jackpots:</label>
                <input type="number" name="jackpots" id="jackpots" min="{{ env('MIN_JACKPOT') }}" required class="input input-bordered w-full mt-2" value="500">
            </div>

            <div class="form-control py-2">
                <label for="start_date" class="block font-medium text-sm text-base-700">Start Date:</label>
                <input type="date" name="start_date" id="start_date" min="{{ now()->toDateString('Y-m-d') }}" max="{{ now()->addYears(1)->toDateString('Y-m-d') }}" value="{{ now()->toDateString('Y-m-d') }}" required class="input input-bordered w-full mt-2">
            </div>
            <div class="form-control py-2">
                <label for="end_date" class="block font-medium text-sm text-base-700">End Date:</label>
                <input type="date" name="end_date" id="end_date" min="{{ now()->toDateString('Y-m-d') }}" max="{{ now()->addYears(3)->toDateString('Y-m-d') }}" value="{{ now()->addDays(30)->toDateString('Y-m-d') }}" required class="input input-bordered w-full mt-2">
            </div>
            <div class="form-control py-2">
                <label for="image" class="block font-medium text-sm text-base-700">Upload Image:</label>
                <input type="file" name="image" id="image" class="input input-bordered w-full mt-2">
            </div>
            
            <div class="flex justify-end mt-4"><button type="submit" class="btn btn-primary px-6">Create Product</button></div>
        </form>
    </div>
    </x-admin.wrapper>