@extends('main')
  
@section('content')
@if(session('cart'))

<div class="container">
    <div class="row">
        <div class="col-md-8 offset-md-2">
            <div class="card mt-5">
                <h3 class="card-header p-3">Checkout</h3>
                <div class="card-body">

                    @session('success')
                        <div class="alert alert-success" role="alert"> 
                            {{ $value }}
                        </div>
                    @endsession
          
                    <form id='checkout-form' method='post' action="{{ route('checkout.post') }}">   
                        @csrf    
                        <h5>Order Details</h5>
                        @foreach(session('cart') as $id => $item)
                            <div><strong>Product Name</strong>: {{ $item['name'] }}</div>
                            <div><strong>Product Price</strong>: ${{ $item['price'] * $item['quantity'] }}</div>
                            <input type="hidden" name="pd_name" value="{{ $item['name'] }}">
                            <input type="hidden" name="pd_price" value="{{ $item['price'] * $item['quantity'] }}">
                            <br>
                        @endforeach
                        
                        <br>    
                        <strong>Card Name:</strong>
                        <input type="input" class="form-control" name="name" placeholder="Enter Name">
                        
                        <input type='hidden' name='stripeToken' id='stripe-token-id'>                              
                        <br>
                        <div id="card-element" class="form-control" ></div>
                        <button 
                            id='pay-btn'
                            class="btn btn-success mt-3"
                            type="button"
                            style="margin-top: 20px; width: 100%;padding: 7px;"
                            onclick="createToken()">PAY $1
                        </button>
                    <form>
                </div>
            </div>
        </div>
    </div> 
</div>
@else
     <div class="alert danger center"><h3> Your cart is empty </h3></div>      
@endif
@endsection

@section('scripts')
<script src="https://js.stripe.com/v3/"></script>
<script type="text/javascript">
  
    var stripe = Stripe('{{ env('STRIPE_KEY') }}')
    var elements = stripe.elements();
    var cardElement = elements.create('card');
    cardElement.mount('#card-element');
  
    /*------------------------------------------
    --------------------------------------------
    Create Token Code
    --------------------------------------------
    --------------------------------------------*/
    function createToken() {
        document.getElementById("pay-btn").disabled = true;
        stripe.createToken(cardElement).then(function(result) {
   
            if(typeof result.error != 'undefined') {
                document.getElementById("pay-btn").disabled = false;
                alert(result.error.message);
            }
  
            /* creating token success */
            if(typeof result.token != 'undefined') {
                document.getElementById("stripe-token-id").value = result.token.id;
                document.getElementById('checkout-form').submit();
            }
        });
    }
</script>
@endsection