<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\Admin\ProductsController;
use Illuminate\Support\Facades\Route;


//Route::get('/', function () {     return view('welcome'); });

Route::get('/', [ProductController::class, 'index']);
//Route::post('/cart/add', [ProductController::class, 'addToCart'])->name('cart.add');

Route::get('/products-list', [ProductController::class, 'index'])->name('product.index');  

Route::middleware('auth')->group(function () {
    Route::get('/cart-list', [ProductController::class, 'productCart']);
    Route::post('add-to-cart', [ProductController::class, 'addProductToCart'])->name('add-product-to-shopping-cart');
    Route::delete('/delete-cart-item', [ProductController::class, 'deleteItem'])->name('delete.cart.item');
    Route::get('/checkout', [ProductController::class, 'stripe'])->name('checkout.index');
    Route::post('/checkout', [ProductController::class, 'stripePost'])->name('checkout.post');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

//Route::get('/approvals', [ListingController::class, 'show'])->middleware('role:super-admin');

Route::middleware('auth')->group(function () {
    Route::get('admin/products', [App\Http\Controllers\Admin\ProductsController::class, 'index'])->name('admin.products.index');
    Route::get('admin/products-create', [App\Http\Controllers\Admin\ProductsController::class, 'create'])->name('admin.products.create');
    Route::post('admin/products/add', [App\Http\Controllers\Admin\ProductsController::class, 'store'])->name('admin.products.store');;
    Route::get('admin/products/{id}/edit', [App\Http\Controllers\Admin\ProductsController::class, 'edit'])->name('admin.products.edit');
    Route::put('admin/products', [App\Http\Controllers\Admin\ProductsController::class, 'update'])->name('admin.products.update');
    Route::delete('admin/products/{id}', [App\Http\Controllers\Admin\ProductsController::class, 'destroy'])->name('admin.products.destroy');
});

Route::middleware('auth')->group(function () {
    Route::get('admin/bids', [App\Http\Controllers\Admin\BidsController::class, 'index'])->name('admin.bids.index');
    Route::get('admin/bids/{id}', [App\Http\Controllers\Admin\BidsController::class, 'detail'])->name('admin.bids.view');
    Route::get('admin/bids/user/{id}', [App\Http\Controllers\Admin\BidsController::class, 'userdetail'])->name('admin.bids.user');
});

require __DIR__.'/auth.php';
