
<!DOCTYPE html>
<html>
<head>
    <title><?php echo e(config('app.name')); ?></title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <!--<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">-->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.6.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,600&display=swap" rel="stylesheet" /> 

    <!-- custom css starts here -->
    <link href="<?php echo e(asset('assets/css/animate.css')); ?> " rel="stylesheet">
    <link href="<?php echo e(asset('assets/fontawesome5/css/all.min.css')); ?>" rel="stylesheet">
    <!--
    <link href="<?php echo e(asset('assets/slick/slick-theme.css')); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo e(asset('assets/slick/slick.css')); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo e(asset('assets/css/slicknav.css')); ?>" rel="stylesheet" type="text/css">
    -->
    <link href="<?php echo e(asset('assets/css/fancybox.css')); ?>" rel="stylesheet" type="text/css">
    <!--<link href="<?php echo e(asset('assets/css/bootstrap.css')); ?>" rel="stylesheet">-->
    <link href="<?php echo e(asset('assets/css/custom.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/wp-custom.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/responsive.css')); ?>" rel="stylesheet">
    <!-- custom css end -->
</head>
<body class="font-sans antialiased dark:bg-black dark:text-white/50">

<?php if(Route::current()->getName() !== 'checkout.index'): ?>
    <!-- banner start -->
    <section class="banner-wrap">
            <img src="<?php echo e(asset('assets/images/banner.jpg')); ?>" alt="" class="baner-img">
            <div class="banner-text-box">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="banner-items-img">
                                <img src="<?php echo e(asset('assets/images/banner-items1.png')); ?>" alt="" class="banner-items1">
                                <img src="<?php echo e(asset('assets/images/banner-items2.png')); ?>" alt="" class="banner-items2">
                                <img src="<?php echo e(asset('assets/images/banner-items3.png')); ?>" alt="" class="banner-items3">
                            </div>
                            <img src="<?php echo e(asset('assets/images/banner-1.png')); ?>" alt="" class="banner-main-img">
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <!-- banner end -->
   <?php endif; ?>
<nav class="navbar navbar-expand-lg bg-light">
        <div class="container">
          <a class="navbar-brand" href="<?php echo e(URL('/')); ?>">Home</a>
          <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNavDropdown" aria-controls="navbarNavDropdown" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
          </button>
          <div class="collapse navbar-collapse" id="navbarNavDropdown">
            <ul class="navbar-nav ms-auto">
                <?php if(auth()->guard()->guest()): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e((request()->is('login')) ? 'active' : ''); ?>" href="<?php echo e(route('login')); ?>">Login</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e((request()->is('register')) ? 'active' : ''); ?>" href="<?php echo e(route('register')); ?>">Register</a>
                    </li>
                <?php else: ?>    
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <?php echo e(Auth::user()->name); ?>

                        </a>
                        <ul class="dropdown-menu">                        
                        <li>  <a  href="<?php echo e(url('/dashboard')); ?>"  class="dropdown-item">Dashboard</a> </li>
                        <li>  <a  href="<?php echo e(url('/profile')); ?>"  class="dropdown-item">Profile</a> </li>        
                        <li><a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                            onclick="event.preventDefault();
                            document.getElementById('logout-form').submit();"
                            >Logout</a>
                            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                            </form>
                        </li>
                        </ul>
                    </li>
                <?php endif; ?>
            </ul>
          </div>
        </div>
    </nav>
<div className="bg-gray-50 text-black/50 dark:bg-black dark:text-white/50">    
    <div class="relative min-h-screen flex flex-col items-center justify-center selection:bg-[#FF2D20] selection:text-white">
        <div class="relative w-full max-w-2xl px-6 lg:max-w-7xl">    
<header class="grid grid-cols-2 items-center gap-2 py-10 lg:grid-cols-3">    
        <div class="flex lg:justify-center lg:col-start-2">    </div>   
</header> 

<div class="container mt-5">


   <!-- <h2 class="mb-3"><?php echo e(config('app.name')); ?></h2>-->
        
    <?php
    $totalQuantity = 0;
    ?>
    
    <?php if(session('cart')): ?>
    <?php $__currentLoopData = session('cart'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
        $totalQuantity += $item['quantity'];
        ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    <div class="col-12" style="display:none;">
        <div class="dropdown" >
            <a class="btn btn-outline-dark" href="<?php echo e(url('cart-list')); ?>">
               <i class="fa fa-shopping-cart" aria-hidden="true"></i> Cart <span class="badge text-bg-danger" id="cart-quantity"><?php echo e($totalQuantity); ?></span>
            </a>
        </div>
    </div>
</div>

<div class="container mt-4">
    <?php if(session('success')): ?>
        <div class="alert alert-success">
          <?php echo e(session('success')); ?>

        </div> 
    <?php endif; ?>
    <?php echo $__env->yieldContent('content'); ?>
</div>
  
<?php echo $__env->yieldContent('scripts'); ?>

</div>
</div>

<div class="container mt-4"></div> 
   <div class="copy-right">
     <p>Copyrights © 2024 TestYourLuck - All Rights Reserved</p>
   </div>
   
   

    <!--<script src="<?php echo e(asset('assets/js/jquery-3.6.0.min.js')); ?>"></script>-->
    <script src="<?php echo e(asset('assets/js/wow.js')); ?>"></script>
    <!--<script src="<?php echo e(asset('assets/slick/slick.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/slick/slick.min.js')); ?>"></script>-->
    <script src="<?php echo e(asset('assets/js/jquery.slicknav.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/fancybox.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/font-awesome.js')); ?>"></script>
    <!--<script src="<?php echo e(asset('assets/js/bootstrap.j')); ?>"></script>-->
    <script src="<?php echo e(asset('assets/js/font.js')); ?>"></script>
    <!--<script src="<?php echo e(asset('assets/js/custom.js')); ?>"></script>-->
    <?php if(Route::current()->getName() !== 'checkout.index'): ?>
    <div id="preloader">
        <div id="status">
            <img src="<?php echo e(asset('assets/images/prelodar-logo.png')); ?>" alt="">
        </div>
    </div>
    <script>
        $(window).on('load', function() {
        $('#status').delay(850).fadeIn(500).delay(1000).queue(function(next) {
            $(this).css('animation', 'bounce 1s ease'); // Add bounce animation
            next(); // Proceed to the next function in the queue
        }).delay(1000).fadeOut(500); // Fade out after bounce
        $('#preloader').delay(2350).fadeOut('slow', function() { // Adjusted delay for preloader
            $('body').css({'overflow': 'visible'}); // Allow body overflow after preloader fade out
        });
        });
    </script>
    <?php endif; ?>

</body>
</html><?php /**PATH C:\xampp\htdocs\user-reward\resources\views/main.blade.php ENDPATH**/ ?>