
  
<?php $__env->startSection('content'); ?>
<?php if(session('cart')): ?>
<table id="cart" class="table table-bordered">
    <thead>
        <tr>
            <th>Product</th>
            <th>Price</th>
            <th>Total</th>
            <th></th>
        </tr>
    </thead>
    <tbody>
        <?php $total = 0 ?>
       
       
            <?php $__currentLoopData = session('cart'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                
                <tr rowId="<?php echo e($id); ?>">
                    <td data-th="Product">
                        <div class="row">
                            <div class="col-sm-3 hidden-xs"><img src="<?php echo e(isset($item['poster']) ? $item['poster'] : 'N/A'); ?>" class="card-img-top"/></div>
                            <div class="col-sm-9">
                                <h4 class="nomargin"><?php echo e($item['name']); ?></h4>
                            </div>
                        </div>
                    </td>
                    <td data-th="Price">$<?php echo e($item['price']); ?></td>
                   
                    <td data-th="Subtotal" class="text-center">$<?php echo e($item['price'] * $item['quantity']); ?></td>
                    <td class="actions">
                        <a class="btn btn-outline-danger btn-sm delete-item">Delete</a>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
       
    </tbody>
    <tfoot>         
        <tr>
            <td colspan="5" class="text-right">
                <a href="<?php echo e(url('/products-list')); ?>" class="btn btn-primary"><i class="fa fa-angle-left"></i> Continue Shopping</a>
                <a href="<?php echo e(url('/checkout')); ?>"><button class="btn btn-danger">Checkout</button></a>
            </td>
        </tr>
    </tfoot>
</table>
<?php else: ?>
    <div class="alert">cart is empty</div>
<?php endif; ?>
<?php $__env->stopSection(); ?>
  
<?php $__env->startSection('scripts'); ?>
<script type="text/javascript">
  
    $(".delete-item").click(function (e) {
        e.preventDefault();
  
        var ele = $(this);
  
        if(confirm("Do you really want to delete?")) {
            $.ajax({
                url: '<?php echo e(route('delete.cart.item')); ?>',
                method: "DELETE",
                data: {
                    _token: '<?php echo e(csrf_token()); ?>', 
                    id: ele.parents("tr").attr("rowId")
                },
                success: function (response) {
                    window.location.reload();
                }
            });
        }
    });
  
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\user-reward\resources\views/cart.blade.php ENDPATH**/ ?>