<x-admin.wrapper>   
    <x-slot name="title">       
       <div><img src="{{asset('storage')}}/{{ $results[0]->pd_image }}" width="150">  {{ __('Bid Name') }}   : <b>{{ $results[0]->pd_name }}</b>  ({{ count($results) }})
            <br>{{ __('Bid Description') }} : {{ $results[0]->pd_descrip }}
            <br>{{ __('Created At') }} : {{ $results[0]->pd_created }}
       </div>
    </x-slot> 
    <div class="py-2">
        <div class="min-w-full  border-base-200 shadow overflow-x-auto">
            <x-admin.grid.table>
                <x-slot name="head">
                    <tr class="bg-base-200">
                        <x-admin.grid.th>
                        {{ __('User Name') }}
                        </x-admin.grid.th>
                        <x-admin.grid.th>
                        {{ __('Email') }}
                        </x-admin.grid.th>
                        <x-admin.grid.th>
                            {{ __('Bid Placed On') }}
                        </x-admin.grid.th>                       
                        <x-admin.grid.th>
                            {{ __('Actions') }}
                        </x-admin.grid.th>                       
                    </tr>
                </x-slot>
                <x-slot name="body">
                    @foreach($results as $result)
                        <tr>
                            <x-admin.grid.td>
                                <div class="text-sm text-gray-900" style="margin-left:10px;">
                                    {{ $result->name }}
                                </div>
                            </x-admin.grid.td>
                            <x-admin.grid.td>
                                <div class="text-sm text-gray-900">
                                {{ $result->email }}
                                </div>
                            </x-admin.grid.td>
                            <x-admin.grid.td>
                                <div class="text-sm text-gray-900">
                                {{ $result->bid_date }}
                                </div>
                            </x-admin.grid.td>
                            
                            <x-admin.grid.td>
                            <a href="{{route('admin.bids.user', $result->id) }}" class="btn btn-square btn-ghost">View User</a>
                            </x-admin.grid.td>   
                        </tr>
                    @endforeach
                    @empty($results)
                        <tr>
                            <td colspan="2">
                                <div class="flex flex-col justify-center items-center py-4 text-lg">
                                    {{ __('No Result Found') }}
                                </div>
                            </td>
                        </tr>
                    @endempty
                </x-slot>
            </x-admin.grid.table>
        </div>
    </div>
</x-admin.wrapper>