<x-admin.wrapper>
    <x-slot name="title">
        {{ __('Bids') }}
    </x-slot>   
    
    <div class="py-2">
        <div class="min-w-full  border-base-200 shadow overflow-x-auto">
            <x-admin.grid.table>
                <x-slot name="head">
                    <tr class="bg-base-200">
                    <x-admin.grid.th>
                        {{ __('Image') }}
                        </x-admin.grid.th>
                        <x-admin.grid.th>
                        {{ __('Bid Name') }}
                        </x-admin.grid.th>
                        <x-admin.grid.th>
                        {{ __('Description') }}
                        </x-admin.grid.th>
                        <x-admin.grid.th>
                            {{ __('Total Bids') }}
                        </x-admin.grid.th>                       
                        <x-admin.grid.th>
                            {{ __('Actions') }}
                        </x-admin.grid.th>                       
                    </tr>
                </x-slot>
                <x-slot name="body">
                    @foreach($results as $result)
                        <tr>
                            <x-admin.grid.td>
                                <div class="text-sm text-gray-900" style="margin-left:10px;">
                                   <img src="{{asset('storage')}}/{{ $result->pd_image }}" width="70">
                                </div>
                            </x-admin.grid.td>
                            <x-admin.grid.td>
                                <div class="text-sm text-gray-900" style="margin-left:10px;">
                                    {{ $result->pd_name }}
                                </div>
                            </x-admin.grid.td>
                            <x-admin.grid.td>
                                <div class="text-sm text-gray-900">
                                {{ $result->pd_descrip }}
                                </div>
                            </x-admin.grid.td>
                            <x-admin.grid.td>
                                <div class="text-sm text-gray-900">
                                {{ $result->total_bids }}
                                </div>
                            </x-admin.grid.td>
                            
                            <x-admin.grid.td>
                            <a href="{{route('admin.bids.view', $result->pd_id) }}" class="btn btn-square btn-ghost">View Details</a>
                            </x-admin.grid.td>   
                        </tr>
                    @endforeach
                    @empty($results)
                        <tr>
                            <td colspan="2">
                                <div class="flex flex-col justify-center items-center py-4 text-lg">
                                    {{ __('No Result Found') }}
                                </div>
                            </td>
                        </tr>
                    @endempty
                </x-slot>
            </x-admin.grid.table>
        </div>
    </div>
</x-admin.wrapper>