@extends('main')
   
@section('content')
 
<style>
    .img-center{
    /* width: 150px; */
    height: 130px;
    /* align-content: space-evenly; */
    display: block;
    margin-left: auto;
    margin-right: auto;
    width: 50%;
}
.card{ text-align: center;}
</style>
<div class="row">
    @foreach($products as $product)
        <div class="col-md-3 col-6 mb-4">
            <div class="card">
                <img src="{{ asset('storage/'.$product->image) }}" alt="{{ $product->name }}" class="card-img-top img-center">
                <div class="card-body">
                    <h4 class="card-title">{{ $product->name }}</h4>
                    <p>{{ $product->descrip }}</p>
                    <input type="hidden" class="product-quantity" value="1">
                    <p>({{ $product->total_bids }})</p>
                <p class="btn-holder">
                @auth
                    <button class="btn btn-outline-danger add-to-cart" data-product-id="{{ $product->id }}">Place Bid</button>
                @else
                <button type="button" class="btn btn-outline-danger add-to-cart" data-bs-toggle="modal" data-bs-target="#exampleModal">
                    Place Bid
                </button>
                @endauth    
                </p>
                </div>
            </div>
        </div>
    @endforeach
</div>

<!-- Modal start -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
            <div class="modal-header">            
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
            <h3> Please <a href="{{ route('login') }}">login</a>/<a href="{{ route('register') }}">Register</a> and then place bid</h3>
            </div>        
            </div>
        </div>
    </div>
<!-- Modal end-->    

@endsection

@section('scripts')

<script type="text/javascript">
    $(".add-to-cart").click(function (e) {
        e.preventDefault();
        
        @auth
            var productId = $(this).data("product-id");
            var productQuantity = $(this).siblings(".product-quantity").val();
            var cartItemId = $(this).data("cart-item-id");

            $.ajax({
                url: "{{ route('add-product-to-shopping-cart') }}",
                method: "POST",
                data: {
                    _token: '{{ csrf_token() }}', 
                    product_id: productId,
                    quantity: productQuantity,
                    cart_item_id: cartItemId
                },
                success: function (response) {
                    $('#cart-quantity').text(response.cartCount);
                    //alert('Cart Updated');
                    console.log(response);
                    window.location.href = "{{ route('checkout.index') }}";
                },
                error: function (xhr, status, error) {
                    // Handle errors (e.g., display an error message)
                    console.error(xhr.responseText);
                }
            });
        @else
        $('#exampleModalCenter').modal({
        keyboard: false
        });
        @endauth
    });
</script>


@endsection