<?php namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;
use Illuminate\Support\Facades\DB;
use App\Models\Products;
use App\Models\Bids;
use App\Models\BidWinners;
use App\Models\User;


class BidsController extends Controller
{

   /**
     * Display a listing of the resource.
     *
     * @return View
     */
    public function index(Request $request): View
    {
        $user = auth()->user();
        if($user->role !=='admin'){exit;}

        $results = DB::table('products')                
                ->leftJoin('bids', 'products.id', '=', 'bids.product_id')                
                ->select('products.name as pd_name','products.image as pd_image','products.descrip as pd_descrip','products.bid_status as bid_status','products.created_at as pd_created', 
                          DB::raw('COUNT(bids.product_id) as total_bids'),'products.id as pd_id')
                ->groupBy('products.id','products.name','products.image','products.descrip','products.created_at','products.bid_status') 
                ->having('total_bids', '>=', 1)                
                ->orderBy('bids.updated_at', 'desc')
                ->get();
        //echo '<pre>'; print_r($results);

        return view('admin.bids.index', compact('results'));
    } 

     /**
     * Display a listing of the resource.
     *
     * @return View
     */
    public function detail($id): View
    {
        $user = auth()->user();
        if($user->role !=='admin'){exit;}

        
        $results = DB::table('bids')                
                ->leftJoin('users', 'bids.user_id', '=', 'users.id')
                ->leftJoin('products', 'bids.product_id', '=', 'products.id')     
                ->where('bids.product_id', $id)             
                ->select('products.name as pd_name','products.image as pd_image','products.descrip as pd_descrip','products.created_at as pd_created',
                        'users.id','users.name','users.email','products.id as pd_id', DB::raw('count(bids.user_id) as user_bids'))
                ->groupBy('users.id','users.name','users.email','products.name', 'products.image','products.descrip','products.created_at','products.id')            
                ->orderBy('bids.updated_at', 'desc')            
                ->get();
           
         // $results = DB::raw('SELECT products.name as pd_name,products.image as pd_image,products.descrip as pd_descrip, products.created_at as pd_created, users.*,products.id as pd_id, count(bids.user_id) as user_bids FROM `bids` left join users on bids.user_id = users.id left join products on bids.product_id = products.id where bids.product_id = 1 group by users.id;') 
                        ;     
        //echo '<pre>'; print_r($results); exit;

        return view('admin.bids.detail', compact('results'));
    } 

    /**
     * Display a user details.
     *
     * @return View
     */
    public function userdetail($id): View
    {
        $user = auth()->user();
        if($user->role !=='admin'){exit;}

        $results = DB::table('bids')                
                ->leftJoin('users', 'bids.user_id', '=', 'users.id')
                ->leftJoin('products', 'bids.product_id', '=', 'products.id')     
                ->where('bids.user_id', $id)             
                ->select('products.name as pd_name','products.image as pd_image','products.descrip as pd_descrip','users.name','users.email','users.id',
                        'users.created_at','products.id as pd_id', DB::raw('count(bids.product_id) as product_bids')) 
                ->groupBy('products.id','users.name','users.email','users.created_at','products.name', 'products.image','products.descrip','products.created_at',
                          'users.id') 
                ->orderBy('bids.updated_at', 'desc')            
                ->get();

                
       // echo '<pre>'; print_r($results); exit;

        return view('admin.bids.user', compact('results'));
    } 

    /****
    * Display list of winners
    *
    * @return View
    *****/     
    public function bidwinners(): View
    {
       
        $user = auth()->user();
        if($user->role !=='admin'){exit;}
        
        $results = Db::table('bid_winners')
                        ->leftJoin('users', 'bid_winners.user_id', '=', 'users.id')
                        ->leftJoin('products', 'bid_winners.product_id', '=', 'products.id')   
                        ->select('products.name as pd_name','products.image as pd_image','products.descrip as pd_descrip','users.name','users.email','users.id',
                        'users.created_at','products.id as pd_id','bid_winners.id' ,'bid_winners.bid_id','bid_winners.drawn_date') 
                        ->orderBy('bid_winners.updated_at', 'desc')            
                        ->get();
        //echo '<pre>'; print_r($results); exit;
        return view('admin.bids.bidwinners', compact('results'));
        
    }

    /****
    * Display list of products for draw bid result
    * product's  end date is less then current date
    * product's status should be pending/open
    * @return View
    *****/ 
    public function bid_draw_list(): View
    {
        $user = auth()->user();
        if($user->role !=='admin'){exit;}

        $results = DB::table('products')                
                ->leftJoin('bids', 'products.id', '=', 'bids.product_id')                
                ->select('products.name as pd_name','products.image as pd_image','products.descrip as pd_descrip','products.bid_status as bid_status','products.created_at as pd_created', 
                          'products.start_date','products.end_date','products.jackpots',DB::raw('COUNT(bids.product_id) as total_bids'),'products.id as pd_id')
                ->where('products.bid_status', 'open')
                ->where('products.end_date', '<=', date('Y-m-d'))            
                ->groupBy('products.id','products.name','products.image','products.descrip','products.created_at','products.bid_status','products.start_date','products.end_date','products.jackpots') 
                ->having('total_bids', '>=', 1)                
                ->orderBy('bids.updated_at', 'desc')
                ->get();

        return view('admin.bids.bid_draw_list', compact('results'));   
    }

     /**********
     * 
     * Draw result 
     * pick random user from bids table wich related to current product
     *  declare that user as winner
     * 
     *********/
     public function bid_draw_result(Request $request): RedirectResponse
     {
        $user = auth()->user();        
        if($user->role !== 'admin'){exit;}

        $id = $request->get('id');

        $bids = Bids::where('product_id', $id)->get();
        $randomBid = $bids->random();
        $winner = User::find($randomBid->user_id);

        $product = Products::findOrFail($id);
        $update_data = ['bid_status' => "processing"];
        $product->update($update_data);

        $add_data =[
                   'user_id'    =>  $winner->id,
                   'user_name'  =>  $winner->name,
                   'user_email' =>  $winner->email,
                   'product_id' =>  $id,
                   'bid_id'     =>  $randomBid->id,
                   'drawn_date' =>  date('Y-m-d')
                   ];
        BidWinners::create($add_data);

        //return redirect()->route('admin.bids.winners')->with('success', "Bid Winner is of Product $id and Bid.".$randomBid->id." user is ".$winner->name);
        return redirect()->route('admin.bids.winners')->with('success', 'Bid Winner is '.$winner->name.' '.$winner->email.' of Product '.$id.' '.$product->name.' and Bid # '.$randomBid->id.' .');

     }
}