<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('image');
            $table->string('slug_url');
            $table->longText('descrip');
            $table->decimal('price', 8, 2);
            $table->boolean('status');
            $table->timestamp('start_date', precision: 0);
            $table->timestamp('end_date', precision: 0);
            $table->enum('bid_status', ['pending', 'processing','complete','closed','cancelled','open']);
            $table->integer('jackpots');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
