<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('order', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->index()->constrained()->onUpdate('cascade')->onDelete('cascade'); //->constrained()->onUpdate('cascade')->onDelete('cascade')
            $table->string('user_name');
            $table->string('user_email');
            $table->string('ip_address', 45)->nullable();
            $table->decimal('tax', 8, 2)->default(0.00);
            $table->decimal('discount', 8, 2)->default(0.00);
            $table->decimal('total', 8, 2)->default(0.00);
            $table->decimal('grand_total', 8, 2)->default(0.00);            
            $table->enum('status', ['pending', 'processing','complete','closed','cancelled']);
            $table->timestamps();
        });

        Schema::create('order_items', function (Blueprint $table) {
            $table->id();            
            $table->string('product_name');
            $table->decimal('price', 8, 2)->default(0.00); 
            $table->integer('quantity')->unsigned()->default(1);          
            $table->decimal('tax', 8, 2)->default(0.00);
            $table->decimal('discount', 8, 2)->default(0.00);  
            $table->foreignId('order_id')->index();
            $table->foreignId('product_id')->index();          
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('order');
        Schema::dropIfExists('order_items');
    }
};
