@extends('main')
   
@section('content') 

<!-- luxk today start -->
<section class="luck-today-wrap">
        <div class="container">
            <div class="row d-flex">
               <div class="col-lg-3">
                <div class="lucky-select">
                    <select name="Sorting" id="">
                        <option value="Default Sorting" hidden selected>Default Sorting</option>
                        <option value="">2</option>
                        <option value="">2</option>
                        <option value="">2</option>
                    </select>
                </div>
               </div>
               <div class="col-lg-6">
                <div class="luck-today-main-text">
                    <h2>{{ config('app.name') }}</h2>
                </div>
               </div>
               <div class="col-lg-3">
                <div class="showing-text">
                    <p>Showing 1-{{ count($paginatedProducts) }} of {{ count($products) }} results</p>
                </div>
               </div>
            </div>
            <div class="row mt-3">               
                
                @foreach($paginatedProducts as $product)
                <div class="col-lg-3">
                    <div class="luck-draw-prd-box">
                        <div class="luck-draw-prd-img">
                            <img src="{{ asset('storage/'.$product->image) }}" alt="{{ $product->name }}">
                        </div>
                        <div class="lucky-draw-prd-text">
                            <h3>{{ $product->name }}</h3>
                            <ul>
                                <li><h4>{{ $product->jackpots - $product->total_bids }}+ <span>Jackpots Available</span></h4></li>
                                <li><h4>({{ $product->total_bids }})+  <span>Current Enrolled</span></h4></li>
                            </ul>
                            @auth
                                <button class="btn btn-outline-danger add-to-cart" data-product-id="{{ $product->id }}">BID NOW</button>
                            @else
                                <button type="button" class="btn btn-outline-danger add-to-cart" data-bs-toggle="modal" data-bs-target="#exampleModal">
                                    BID NOW
                                </button>
                            @endauth
                        </div>
                    </div>
                </div>
                @endforeach
                {{ $paginatedProducts->links() }}
            </div>
        </div>
    </section>
   <!-- luxk today end -->

<!-- Modal start -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
            <div class="modal-header">            
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
            <h3> Please <a href="{{ route('login') }}">login</a>/<a href="{{ route('register') }}">Register</a> and then place bid</h3>
            </div>        
            </div>
        </div>
    </div>
<!-- Modal end-->    

@endsection

@section('scripts')

<script type="text/javascript">
    $(".add-to-cart").click(function (e) {
        e.preventDefault();
        
        @auth
            var productId = $(this).data("product-id");
            var productQuantity = $(this).siblings(".product-quantity").val();
            var cartItemId = $(this).data("cart-item-id");

            $.ajax({
                url: "{{ route('add-product-to-shopping-cart') }}",
                method: "POST",
                data: {
                    _token: '{{ csrf_token() }}', 
                    product_id: productId,
                    quantity: productQuantity,
                    cart_item_id: cartItemId
                },
                success: function (response) {
                    $('#cart-quantity').text(response.cartCount);
                    //alert('Cart Updated');
                    console.log(response);
                    window.location.href = "{{ route('checkout.index') }}";
                },
                error: function (xhr, status, error) {
                    // Handle errors (e.g., display an error message)
                    console.error(xhr.responseText);
                }
            });
        @else
        $('#exampleModalCenter').modal({
        keyboard: false
        });
        @endauth
    });
</script>


@endsection