<?php

declare(strict_types=1);

use Robo\Tasks;

require_once 'vendor/autoload.php';
/**
 * This is project's console commands configuration for Robo task runner.
 *
 * @see https://robo.li/
 */
class RoboFile extends Tasks
{
    protected $docs = [
        'docs/Stub.md' => 'Codeception\Stub',
        'docs/Expected.md' => 'Codeception\Stub\Expected',
        'docs/StubTrait.md' => 'Codeception\Test\Feature\Stub',
    ];

    public function docs()
    {
        foreach ($this->docs as $file => $class) {
            if (!class_exists($class, true) && !trait_exists($class, true)) {
                throw new Exception('ups');
            }
            $this->say("Here goes, $class");
            $this->taskGenDoc($file)
                ->docClass($class)
                ->filterMethods(function(ReflectionMethod $method) {
                    if ($method->isConstructor() or $method->isDestructor()) return false;
                    if (!$method->isPublic()) return false;
                    if (str_starts_with($method->name, '_')) return false;
                    if (str_starts_with($method->name, 'stub')) return false;
                    return true;
                })
                ->processMethodDocBlock(
                    function (ReflectionMethod $m, $doc) {
                        $doc = str_replace(array('@since'), array(' * available since version'), $doc);
                        $doc = str_replace(array(' @', "\n@"), array("  * ", "\n * "), $doc);
                        return $doc;
                    })
                ->processProperty(false)
                ->run();
        }
    }
}